<?php

class CodeBAR {
	
	private $codeString = '';
	private $codeBin = '';
	
	/**
	* Set to use EAN13
	**/
	private $tabBinEAN13 = array(
		'setA' => ['0001101','0011001','0010011','0111101','0100011','0110001','0101111','0111011','0110111','0001011'],
		'setB' => ['0100111','0110011','0011011','0100001','0011101','0111001','0000101','0010001','0001001','0010111'],
		'setC' => ['1110010','1100110','1101100','1000010','1011100','1001110','1010000','1000100','1001000','1110100']
	);
	
	private $formatEAN13 = array(
		'AAAAAA','AABABB','AABBAB','AABBBA','ABAABB','ABBAAB','ABBBAA','ABABAB','ABABBA','ABBABA'
	);
	
	public function __construct(string $code){
		
		$this->setCodeBar($code);
		
	}
	
	/**
	* SETTING
	**/
	
	// Integrate code string
	public function setCodeBar($code){
		
		$this->codeString = $code;
		$this->binaryConvertEAN13();
		
	}
	
	// Convert to binary
	public function  binaryConvertEAN13() {
		
		for($i = 0; $i < strlen($this->codeString); $i++) {
			
			$c = intval(substr($this->codeString, $i, 1));
			
			if ($i > -1 && $i < 2) {
				$prefix[$i] = $c;
			}
			
			if ($i > 1 && $i < 7) {
				$num_participant[$i-2] = $c;				
			}
			
			if ($i > 6 && $i < 12) {
				$num_article[$i-7] = $c;				
			}			
			
			if ($i == 12) {
				$check_digit = $c;
			}
			
		}
		
		$format = $this->formatEAN13[$prefix[0]];
		
		$binary  = '101'; // open
		
		$set = 'set'.substr($format, 0, 1);
		$set = $this->tabBinEAN13[$set];
		$digit = $set[$prefix[1]];
		$binary .= $digit;	
		
		for($i = 0; $i < count($num_participant); $i++) {
			$set = 'set'.substr($format, $i+1, 1);
			$set = $this->tabBinEAN13[$set];
			$digit = $set[$num_participant[$i]];
			$binary .= $digit;
		}
		
		$binary .= '01010'; // center
		
		for($i = 0; $i < count($num_participant); $i++) {
			$set = $this->tabBinEAN13['setC'];
			$digit = $set[$num_article[$i]];
			$binary .= $digit;
		}
		
		$set = $this->tabBinEAN13['setC'];
		$digit = $set[$check_digit];
		$binary .= $digit;		
		
		$binary .= '101'; // end
		
		$this->codeBin = $binary;
	}
	
	// Creat SVG
	public function codeSVGEAN13() {
		
		$svg  = '<div>';
		$svg .= '<?xml version="1.0" encoding="utf-8"?>';
		$svg .= '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">';
		$svg .= '<svg xmlns="http://www.w3.org/2000/svg" width="400" height="200">';
		
		// Generate Barcode
		for($i=0; $i < strlen($this->codeBin);$i++) {
			$b = substr($this->codeBin, $i, 1);
			if (($i > -1 && $i < 4)
				|| ($i > 45 && $i < 49)
				|| ($i > strlen($this->codeBin)-4 && $i < strlen($this->codeBin)+1)) {
				$h = 127;
			} else {
				$h = 112;
			}
			if($b == '1') {
				$svg .= '<rect x="'.(55+$i*3).'" y="45" width="3" height="'.$h.'" />';
			}			
		}
		
		// Text
		$svg .= '<text class="text-code" x="32" y="185">'.substr($this->codeString,0,1).'</text>';
		for($i = 0; $i < 6; $i++) {
			$svg .= '<text class="text-code" x="'.(70+$i*20).'" y="185">'.substr($this->codeString,$i+1,1).'</text>';
		}
		
		for($i = 0; $i < 6; $i++) {
			$svg .= '<text class="text-code" x="'.(209+$i*20).'" y="185">'.substr($this->codeString,$i+7,1).'</text>';
		}		
		$svg .= '</svg>';
		$svg .= '</div>';
		
		return $svg;
	}
	
	
	/**
	* GETTING
	**/
	
	public function getCodeBar(){
		
		return $this->codeString;
		
	}
	
	public function getCodeBarBin(){
		
		return $this->codeBin;
		
	}	
	
}