<!doctype html>
<html>
<head>
<meta charset="utf-8">
	
<!-- Icone Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	
<title>CRÉATION CODE BAR EAN 13</title>
</head>

<body>
	<style>
		body {
			font-family: "Lucida Grande", "Lucida Sans Unicode", "Lucida Sans", "DejaVu Sans", Verdana, "sans-serif";
			color: #000;			
		}
		
		h1 {
			text-align: center;
		}
		
		#page {
			position: relative;
			width: 100%;
			height: 84vh;
			display: flex;
			flex-direction: row;
			align-items: center;
		}
		
		#barcode {
			position: relative;
			left: calc(50% - 250px);
			width: 500px;
			height: 300px;
			text-align: center;
			border: 5px solid #E3801F;
			border-radius: 20px;
			padding: 1rem 0;
		}
		
		#barcode form {
			display: flex;
			flex-direction: row;
			justify-content: center;
			align-items: center; 
		}
		
		#barcode form img {
			width: auto;
			height: 58px;
			vertical-align: bottom;
		}
		
		#barcode form img:hover {
			filter: drop-shadow(16px 16px 20px blue) invert(75%);
		}
		
		#barcode #svg {
			width: 100%;
			height: 220px;
		}
		
		#barcode input[type="text"] {
			width: 200px;
			padding: 1rem;
			border: 2px solid #E3801F;
			border-right: none;
			border-top-left-radius: 20px;
			border-bottom-left-radius: 20px;
		}
		
		#barcode .text-code {
			font-size: 32px;
		}
		
		#barcode .icon {
			width: 32px;
			height: auto;
			padding: 0 0.25rem;
			margin-right: 0.5rem;
			filter: grayscale(0);
		}
		
		#barcode .icon:hover {
			filter: grayscale(80%);
		}
		
		footer {
			padding: 0 1rem;
			text-align: right;
		}
	</style>
	<?php include('CodeBAR.php'); ?>
	<header>
	<h1>GÉNÉRATEUR DE CODE BAR EAN-13</h1>
	</header>
	<main id="page">
	<section id="barcode">
		<form id="form" method="post">
				<input type="text" placeholder="EAN-13 NUMBER BARCODE" name="code">
				<a href="javascript:generate();" title="GENERATE BARCODE"><img src="barcode.svg" width="auto" height="50"></a>
		</form>
		<div id="svg">
			<?php
			if(isset($_POST['code'])) {
				$code = new CodeBAR($_POST['code']);
				echo '<script>var code = "'.$code->getCodeBar().'";</script>';
				echo $code->codeSVGEAN13();
			}	
			?>
		</div>
		<a href="javascript:printCB();" class="link" title="PRINT BARCODE"><img class="icon" src="print.svg" width="32" height="32"></a>
		<a href="javascript:web(code);" class="link" title="RESEARCH ON THE WEB"><img class="icon" src="web.svg" width="32" height="32"></a>
	</section>
	</main>
	<footer>
		<p>Jean-Bernard MARTINEZ &copy; 2023</p>
	</footer>
	<script>
		function generate() {
			document.getElementById('form').submit();
		}
		function printCB() {
			
			// Définition de la zone à imprimer
			var zone = document.getElementById('svg').innerHTML;
			
			// Ouverture du popup
			var fen = window.open("", "", "height='100%', width='100%',toolbar=0, menubar=0, scrollbars=1, resizable=1,status=0, location=0, left=10, top=10");

			// style du popup
			fen.document.body.style.color = '#000000';
			fen.document.body.style.backgroundColor = '#FFFFFF';
			fen.document.body.style.padding = "20px";

			// Ajout des données a imprimer
			fen.document.title = 'GENERATE BARCODE';
			fen.document.body.innerHTML += " " + zone + " ";

			// Impression du popup
			fen.window.print();
		}
		
		function web(code) {
			var fen = window.open('https://www.google.fr/search?q=' + code, "_blanck", "height='100vw', width='100vh',toolbar=0, menubar=0, scrollbars=1, resizable=1,status=0, location=0, left=10, top=10");			
		}
	</script>
</body>
</html>